<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';
date_default_timezone_set('Europe/London');

// Logins (Today)
$login_sql = "
SELECT m.member_number, m.first_name, m.surname, m.photo, c.scan_time
FROM members m
JOIN current_logins c ON c.member_number = m.member_number
WHERE 1
";

if ($login_search != '') {
    $login_sql .= " AND (
        m.member_number LIKE '%$login_search%' OR
        CONCAT(m.first_name, ' ', m.surname) LIKE '%$login_search%'
    )";
}
$login_sql .= " ORDER BY c.scan_time DESC";
$logins = mysqli_query($conn, $login_sql);

// Logouts (This Month)
$logout_sql = "
SELECT m.member_number, m.first_name, m.surname, m.photo, a.scan_time
FROM members m
JOIN attendance a ON a.member_number = m.member_number
WHERE a.action = 'logout' 
  AND MONTH(a.scan_time) = MONTH(CURDATE()) 
  AND YEAR(a.scan_time) = YEAR(CURDATE())
";
if ($logout_search != '') {
    $logout_sql .= " AND (
        m.member_number LIKE '%$logout_search%' OR
        CONCAT(m.first_name, ' ', m.surname) LIKE '%$logout_search%'
    )";
}
$logout_sql .= " ORDER BY a.scan_time DESC";
$logouts = mysqli_query($conn, $logout_sql);

include 'includes/header.php';
?>

<div class="container my-4">
  <h2><i class="fas fa-calendar-check me-2"></i>Attendance</h2>

  <ul class="nav nav-tabs mt-4" id="attendanceTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="login-tab" data-bs-toggle="tab" data-bs-target="#loginTab" type="button" role="tab">Today's Logins</button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="logout-tab" data-bs-toggle="tab" data-bs-target="#logoutTab" type="button" role="tab">This Month's Logouts</button>
    </li>
  </ul>

  <div class="tab-content pt-3" id="attendanceTabContent">
    <!-- Logins Tab -->
    <div class="tab-pane fade show active" id="loginTab" role="tabpanel">
      <form method="get" class="row mb-3">
        <div class="col-md-4">
          <input type="text" name="login_search" class="form-control" placeholder="Search by name or member #" value="<?= htmlspecialchars($login_search) ?>">
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary w-100">Search</button>
        </div>
      </form>
      <table class="table table-bordered table-hover align-middle">
        <thead class="table-success">
          <tr>
            <th>Photo</th>
            <th>Member #</th>
            <th>Name</th>
            <th>Current Login</th>
            <th>Time</th>
          </tr>
        </thead>
        <tbody>
        <?php if (mysqli_num_rows($logins) == 0): ?>
          <tr><td colspan="5" class="text-center">No logins found today.</td></tr>
        <?php else: while ($row = mysqli_fetch_assoc($logins)): ?>
          <tr>
            <td>
  <img src="uploads/<?= htmlspecialchars($row['photo'] ?: 'default.png') ?>"
       onerror="this.onerror=null; this.src='uploads/default.png';"
       class="img-thumbnail"
       style="max-height:60px;">
</td>

            <td><?= htmlspecialchars($row['member_number']) ?></td>
            <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['surname']) ?></td>
            <td><span class="badge bg-success">Current Login</span></td>
            <td><?= date('d/m/Y H:i', strtotime($row['scan_time'])) ?></td>
          </tr>
        <?php endwhile; endif; ?>
        </tbody>
      </table>
    </div>

    <!-- Logouts Tab -->
    <div class="tab-pane fade" id="logoutTab" role="tabpanel">
      <form method="get" class="row mb-3">
        <div class="col-md-4">
          <input type="text" name="logout_search" class="form-control" placeholder="Search by name or member #" value="<?= htmlspecialchars($logout_search) ?>">
        </div>
        <div class="col-md-2">
          <button class="btn btn-primary w-100">Search</button>
        </div>
      </form>
      <table class="table table-bordered table-hover align-middle">
        <thead class="table-danger">
          <tr>
            <th>Photo</th>
            <th>Member #</th>
            <th>Name</th>
            <th>Action</th>
            <th>Time</th>
          </tr>
        </thead>
        <tbody>
        <?php if (mysqli_num_rows($logouts) == 0): ?>
          <tr><td colspan="5" class="text-center">No logouts found this month.</td></tr>
        <?php else: while ($row = mysqli_fetch_assoc($logouts)): ?>
          <tr>
           <td>
  <img src="uploads/<?= htmlspecialchars($row['photo'] ?: 'default.png') ?>"
       onerror="this.onerror=null; this.src='uploads/default.png';"
       class="img-thumbnail"
       style="max-height:60px;">
</td>

            <td><?= htmlspecialchars($row['member_number']) ?></td>
            <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['surname']) ?></td>
            <td><span class="badge bg-danger">Logout</span></td>
            <td><?= date('d/m/Y H:i', strtotime($row['scan_time'])) ?></td>
          </tr>
        <?php endwhile; endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
